// Form Handler Updates for AI Days Website
// This file contains all the updated form handlers that need to be integrated into script.js

// NEWSLETTER FORM HANDLER (Replace existing)
const newsletterForm = document.getElementById("newsletterForm");
if (newsletterForm) {
  newsletterForm.addEventListener("submit", async function (e) {
    e.preventDefault();

    const emailInput = this.querySelector('input[type="email"]');
    if (!emailInput.value.trim()) {
      showNotification("Please enter a valid email address.", "error");
      return;
    }

    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.textContent = "Subscribing...";
    submitBtn.disabled = true;

    try {
      const formData = { email: emailInput.value };

      await fetch("YOUR_NEWSLETTER_APPS_SCRIPT_URL", {
        method: "POST",
        mode: "no-cors",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      showNotification("Successfully subscribed to newsletter!", "success");
      this.reset();
    } catch (error) {
      console.error("Newsletter subscription error:", error);
      showNotification("Subscription failed. Please try again later.", "error");
    } finally {
      submitBtn.textContent = originalText;
      submitBtn.disabled = false;
    }
  });
}

// CONTACT FORM HANDLER (Replace existing)
const contactForm = document.getElementById("contactForm");
if (contactForm) {
  contactForm.addEventListener("submit", async function (e) {
    e.preventDefault();

    const requiredFields = this.querySelectorAll("[required]");
    let isValid = true;

    requiredFields.forEach((field) => {
      if (!field.value.trim()) {
        field.style.borderColor = "#EF4444";
        isValid = false;
      } else {
        field.style.borderColor = "#E5E7EB";
      }
    });

    if (!isValid) {
      showNotification("Please fill in all required fields.", "error");
      return;
    }

    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.textContent = "Sending...";
    submitBtn.disabled = true;

    try {
      const formInputs = this.querySelectorAll("input, select, textarea");
      const formData = {};

      formInputs.forEach((input) => {
        if (input.name || input.placeholder) {
          const key =
            input.name || input.placeholder.toLowerCase().replace(" ", "");
          formData[key] = input.value;
        }
      });

      await fetch("YOUR_CONTACT_APPS_SCRIPT_URL", {
        method: "POST",
        mode: "no-cors",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      showNotification("Your message has been sent successfully!", "success");
      this.reset();
    } catch (error) {
      console.error("Contact form submission error:", error);
      showNotification(
        "Failed to send message. Please try again later.",
        "error"
      );
    } finally {
      submitBtn.textContent = originalText;
      submitBtn.disabled = false;
    }
  });
}

// PAPER FORM HANDLER (Replace existing)
const paperForm = document.getElementById("paperForm");
if (paperForm) {
  paperForm.addEventListener("submit", async function (e) {
    e.preventDefault();

    const requiredFields = this.querySelectorAll("[required]");
    let isValid = true;

    requiredFields.forEach((field) => {
      if (!field.value.trim()) {
        field.style.borderColor = "#EF4444";
        isValid = false;
      } else {
        field.style.borderColor = "#E5E7EB";
      }
    });

    if (!isValid) {
      showNotification("Please fill in all required fields.", "error");
      return;
    }

    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.textContent = "Submitting...";
    submitBtn.disabled = true;

    try {
      const formData = {
        paperTitle: this.paperTitle.value,
        authors: this.authors.value,
        affiliation: this.affiliation.value,
        submissionType: this.submissionType.value,
        keywords: this.keywords.value,
        abstract: this.abstract.value,
      };

      // Handle file upload if present
      const paperFile = this.paperFile.files[0];
      if (paperFile) {
        // Validate file size (10MB max)
        const maxSizeInBytes = 10 * 1024 * 1024;
        if (paperFile.size > maxSizeInBytes) {
          throw new Error("Paper file must be smaller than 10MB");
        }

        if (paperFile.type !== "application/pdf") {
          throw new Error("Paper must be a PDF file");
        }

        const base64Data = await fileToBase64(paperFile);
        formData.paperFile = {
          name: paperFile.name,
          data: base64Data,
        };
      }

      await fetch("YOUR_PAPER_APPS_SCRIPT_URL", {
        method: "POST",
        mode: "no-cors",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      showNotification("Paper submitted successfully!", "success");
      this.reset();
    } catch (error) {
      console.error("Paper submission error:", error);
      showNotification(
        error.message || "Paper submission failed. Please try again later.",
        "error"
      );
    } finally {
      submitBtn.textContent = originalText;
      submitBtn.disabled = false;
    }
  });
}

// REGISTRATION FORMS HANDLER (Replace existing)
const registrationForms = document.querySelectorAll(".registration-form");
registrationForms.forEach((form) => {
  form.addEventListener("submit", async function (e) {
    e.preventDefault();

    const requiredFields = this.querySelectorAll("[required]");
    let isValid = true;

    requiredFields.forEach((field) => {
      if (!field.value.trim()) {
        field.style.borderColor = "#EF4444";
        isValid = false;
      } else {
        field.style.borderColor = "#E5E7EB";
      }
    });

    if (!isValid) {
      showNotification("Please fill in all required fields.", "error");
      return;
    }

    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.textContent = "Registering...";
    submitBtn.disabled = true;

    try {
      const formInputs = this.querySelectorAll("input, select, textarea");
      const formData = { registrationType: form.id }; // Include form type

      formInputs.forEach((input) => {
        if (input.name || input.id) {
          const key = input.name || input.id;
          formData[key] = input.value;
        }
      });

      await fetch("YOUR_REGISTRATION_APPS_SCRIPT_URL", {
        method: "POST",
        mode: "no-cors",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      showNotification("Registration completed successfully!", "success");

      const modal = this.closest(".modal");
      if (modal) closeModal(modal);
      this.reset();
    } catch (error) {
      console.error("Registration form submission error:", error);
      showNotification("Registration failed. Please try again later.", "error");
    } finally {
      submitBtn.textContent = originalText;
      submitBtn.disabled = false;
    }
  });
});
